(function() {
  // --- DEMO VERSION: 3 download limit ---
  function getDemoDownloadsUsed() {
    return parseInt(localStorage.getItem('tm-demo-downloads') || '0', 10);
  }
  function incrementDemoDownloads() {
    localStorage.setItem('tm-demo-downloads', getDemoDownloadsUsed() + 1);
  }
  function getDemoDownloadsLeft() {
    return 3 - getDemoDownloadsUsed();
  }

  function buttonExists() {
    return document.getElementById('tm-downloader-btn');
  }

  function addDownloadButton() {
    if (buttonExists()) return;

    const video = document.querySelector('video');
    if (!video) {
      setTimeout(addDownloadButton, 1000);
      return;
    }

    let src = "";
    const sourceEl = video.querySelector('source');
    if (sourceEl && sourceEl.src) {
      src = sourceEl.src;
    } else if (video.src) {
      src = video.src;
    }

    if (!src || src === window.location.href) {
      setTimeout(addDownloadButton, 1000);
      return;
    }

    // SVG icon (unchanged)
    const svgIcon = `
      <svg width="18" height="18" viewBox="0 0 28 28" fill="none" style="margin-right:8px;vertical-align:middle;">
        <circle cx="14" cy="14" r="14" fill="url(#grad)"/>
        <defs>
          <linearGradient id="grad" x1="0" y1="0" x2="28" y2="28" gradientUnits="userSpaceOnUse">
            <stop stop-color="#ff512f"/>
            <stop offset="1" stop-color="#dd2476"/>
          </linearGradient>
        </defs>
        <path d="M8.5 15.5L14 21L19.5 15.5" stroke="#fff" stroke-width="2.2" stroke-linecap="round" stroke-linejoin="round"/>
        <path d="M14 21V7" stroke="#fff" stroke-width="2.2" stroke-linecap="round"/>
      </svg>
    `;

    const downloadsLeft = getDemoDownloadsLeft();

    // Download button
    const btn = document.createElement('a');
    btn.id = 'tm-downloader-btn';
    btn.href = src;
    btn.download = '';
    btn.innerHTML = `${svgIcon}<span style="font-size:15px; font-weight:600;">Download</span>`;
    btn.style.display = 'inline-flex';
    btn.style.alignItems = 'center';
    btn.style.justifyContent = 'center';
    btn.style.background = 'linear-gradient(90deg, #FF6A4D 0%, #DD2476 100%)';
    btn.style.color = 'white';
    btn.style.fontSize = '12px';
    btn.style.padding = '7px 12px';
    btn.style.margin = '0 0 0 235px';
    btn.style.borderRadius = '10px';
    btn.style.fontWeight = 'bold';
    btn.style.fontFamily = 'inherit';
    btn.style.textShadow = '0 1px 5px rgba(0,0,0,0.10)';
    btn.style.textAlign = 'center';
    btn.style.textDecoration = 'none';
    btn.style.boxShadow = '0 3px 10px rgba(222,34,118,0.13)';
    btn.style.cursor = 'pointer';
    btn.style.border = 'none';
    btn.style.transition = 'background 0.18s, transform 0.18s';
    btn.onmouseover = () => {
      btn.style.background = 'linear-gradient(90deg, #fc5c7d 0%, #FFD591 100%)';
      btn.style.transform = 'scale(1.07)';
    };
    btn.onmouseout = () => {
      btn.style.background = 'linear-gradient(90deg, #FF6A4D 0%, #DD2476 100%)';
      btn.style.transform = 'scale(1)';
    };

    // DEMO-limited logic
    if (downloadsLeft > 0) {
      btn.addEventListener('click', function() {
        incrementDemoDownloads();
      });
    } else {
      btn.style.opacity = 0.5;
      btn.style.pointerEvents = "none";
      btn.style.filter = "grayscale(0.5)";
    }

    // Japanese hint
    const help = document.createElement('div');
    help.innerHTML = `
      <span style="
        font-size:12px;
        color:#dd2476;
        background:linear-gradient(90deg,#fff0f6 0%, #ffe1ec 100%);
        padding:5px 11px;
        border-radius:7px;
        box-shadow:0 1px 4px #DD247610;
        margin-top:8px;
        display:inline-block;
        font-weight:500;">
        ヒント: 「Download」をクリックし、動画上で右クリックして「名前を付けて動画を保存」を選んでください
      </span>
    `;
    help.style.marginLeft = '65px';

    // Limit lock message (JAPANESE)
    let limitMsg = null;
    if (downloadsLeft <= 0) {
      limitMsg = document.createElement('div');
      limitMsg.innerHTML = `
        <span style="color:#bb0066;font-size:13px;font-weight:600;display:block;">
          利用上限に達しました（残り 0 / 3 回）
        </span>
        <span style="color:#232323;font-size:13px;font-weight:500;display:block;">
          無制限でダウンロードするなら：<a href="https://motiondl.net/full.html" target="_blank" style="color:#ff6a4d;text-decoration:underline;font-weight:700;">フルバージョンを購入</a>
        </span>
      `;
      limitMsg.style.marginLeft = '195px';
      limitMsg.style.marginTop = '7px';
    }

    // Wrapper for button+hint
    const wrapper = document.createElement('div');
    wrapper.id = 'tm-downloader-wrapper';
    wrapper.style.display = 'flex';
    wrapper.style.flexDirection = 'column';
    wrapper.style.alignItems = 'flex-start';
    wrapper.style.margin = '14px 0 8px 0';

    wrapper.appendChild(btn);
    wrapper.appendChild(help);

    if (limitMsg) wrapper.appendChild(limitMsg);

    // Insert wrapper BELOW video player
    let container = video.parentElement;
    if (container.tagName === "VIDEO") container = container.parentElement;
    if (container.nextSibling) {
      container.parentElement.insertBefore(wrapper, container.nextSibling);
    } else {
      container.parentElement.appendChild(wrapper);
    }
  }

  window.addEventListener('DOMContentLoaded', addDownloadButton);
  window.addEventListener('load', addDownloadButton);
  setTimeout(addDownloadButton, 2500);
})();